CREATE OR REPLACE FUNCTION alterPKFunction() RETURNS VOID AS $BODY$
BEGIN
    IF EXISTS (SELECT 1 FROM information_schema.constraint_table_usage
                    WHERE table_name= 'pdv_cupom_nao_fiscal_tef' and
                    	constraint_name = 'pdv_cupom_nao_fiscal_tef_pkey') THEN

		/*
			Deleção da Chave Primária
		*/
		ALTER TABLE public.pdv_cupom_nao_fiscal_tef 
			DROP CONSTRAINT pdv_cupom_nao_fiscal_tef_pkey;

        RAISE NOTICE 'Chave primária "pdv_cupom_nao_fiscal_tef_pkey" removida da tabela "pdv_cupom_nao_fiscal_tef"' ;

    END IF;
		/*
			Atualização do campo CD_TRN_TEF para 0 nos registros que não 
			referem-se à recarga de celular
		*/
		UPDATE pdv_cupom_nao_fiscal_tef 
			SET cd_trn_tef = 0 where cd_trn_tef is null;
		/*
			Adição da Chave Primária com o campo CD_TRN_TEF
		*/
		ALTER TABLE public.pdv_cupom_nao_fiscal_tef
		  ADD CONSTRAINT pdv_cupom_nao_fiscal_tef_pkey
		PRIMARY KEY (cd_emp, cd_filial, cd_cx, cd_ctr, cd_trn_tef);

        RAISE NOTICE 'Chave primária "pdv_cupom_nao_fiscal_tef_pkey" da tabela "pdv_cupom_nao_fiscal_tef" recriada com sucesso!' ;
END;
-- fim bloco principal
$BODY$ LANGUAGE PLPGSQL VOLATILE COST 100;

ALTER FUNCTION alterPKFunction() OWNER TO postgres;
SELECT alterPKFunction();
DROP FUNCTION alterPKFunction();
